package org.msh.tb.bd.tbforms.dhis2.schedule.scheduler;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.*;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.async.QuartzTriggerHandle;
import org.msh.tb.application.tasks.TaskManager;
import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.dhis2.DHIS2AuthenticationService;
import org.msh.tb.bd.tbforms.dhis2.DHIS2DataExportService;
import org.msh.tb.bd.tbforms.dhis2.DHIS2ExportAsyncTask;
import org.msh.tb.bd.tbforms.dhis2.schedule.asynctask.DHIS2ExportTB10ScheduleAsyncTask;
import org.msh.tb.bd.tbforms.dhis2.tb10.DHIS2ExportTB10AsyncTask;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.taskscheduling.ScheduledTask;

import javax.persistence.EntityManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mauri on 07/07/2017.
 */
public abstract class DHIS2ExportationScheduler extends ScheduledTask {

    @In(create=true)
    protected EntityManager entityManager;

    @In(create=true)
    protected DHIS2AuthenticationService dHIS2AuthenticationService;

    @In(create=true)
    protected DHIS2DataExportService dHIS2DataExportService;

    @In
    protected TaskManager taskManager;

    public Map<String, Object> getParams() {
        Map<String, Object> params =  new HashMap<String, Object>();

        List<Tbunit> tbunits = entityManager.createQuery("from Tbunit u where u.dhis2Id is not null and u.dhis2Enabled = true and u.workspace.id = :workspaceId")
                .setParameter("workspaceId", 11) // production environment
                .getResultList();

        // set params
        params.put(DHIS2ExportTB10AsyncTask.PARAM_TBUNITS, tbunits);
        // will get previous quarter, current quarter may not be available for data entry in DHIS2
        params.put(DHIS2ExportAsyncTask.PARAM_SELECTED_QUARTER, Quarter.getCurrentQuarter().getPreviousQuarter());
        params.put(DHIS2ExportAsyncTask.PARAM_DHIS2_AUTH_SERVICE, dHIS2AuthenticationService);
        params.put(DHIS2ExportAsyncTask.PARAM_DHIS2_EXPORT_SERVICE, dHIS2DataExportService);

        return params;
    }

    // irrelevant as this component is not saving transaction log
    @Override
    protected String getEventName() {
        return null;
    }

    // irrelevant as this component is not saving transaction log
    @Override
    protected String getLogDescription() {
        return null;
    }
}
